/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class EventLog
implements Serializable,
Cloneable {
    private static final String TRACE_MASKT = "XFRMEVLT";
    private static final String TRACE_MASKF = "XFRMEVLF";
    private static final String TRACE_MASKD = "XFRMEVLD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "EventLog");
    private LocalizableText eventText;
    private String eventName;
    private LocalizableText[] eventDetailsText;
    private String logId;
    private Date timestamp;

    public EventLog(LocalizableText eventText, LocalizableText[] eventDetailsText, String eventName, String logId) {
        if (this instanceof EventLog) {
            Trace.trace(TRACE_MASKT, "-> EventLog(eventText=" + eventText + ",eventDetailsText=" + eventDetailsText + ",eventName=" + eventName + ",logId=" + logId + ")");
        }
        this.setEventText(eventText);
        this.setEventDetailsText(eventDetailsText);
        this.setEventName(eventName);
        this.setLogId(logId);
        this.timestamp = null;
        if (this instanceof EventLog) {
            Trace.trace(TRACE_MASKT, "<- EventLog()");
        }
    }

    public EventLog(Log logEntry) {
        if (this instanceof EventLog) {
            Trace.trace(TRACE_MASKT, "-> EventLog(logEntry=" + logEntry + ")");
        }
        boolean parseIx = false;
        Object bundleName = null;
        Object key = null;
        this.unmarshalEventText(logEntry);
        this.unmarshalEventDetailsText(logEntry);
        this.setEventName(logEntry.getEventName());
        this.timestamp = logEntry.getTimestamp();
        this.setLogId(logEntry.getLogId());
        if (this instanceof EventLog) {
            Trace.trace(TRACE_MASKT, "<- EventLog()");
        }
    }

    public void setEventText(LocalizableText eventText) {
        this.eventText = eventText;
    }

    public LocalizableText getEventText() {
        return this.eventText;
    }

    public void setEventDetailsText(LocalizableText[] eventDetailsText) {
        this.eventDetailsText = eventDetailsText;
    }

    public LocalizableText[] getEventDetailsText() {
        return this.eventDetailsText;
    }

    public void setEventName(String eventName) {
        int size = eventName.length();
        if (size > 12) {
            size = 12;
        }
        this.eventName = eventName.substring(0, size);
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setLogId(String logId) {
        if (logId == null) {
            logId = "log";
        }
        this.logId = logId;
    }

    public String getLogId() {
        return this.logId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void log() {
        Trace.trace(TRACE_MASKT, "-> log()");
        short user = 0;
        try {
            String eventTextKey = this.getEventText().getKey();
            user = Short.decode(eventTextKey);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        Log log = new Log(0, 0, user, this.getEventName(), null, null, this.getLogId(), null);
        this.marshalEventText(log);
        this.marshalEventDetailsText(log);
        log.log();
        Trace.trace(TRACE_MASKT, "<- log()");
    }

    public Object clone() {
        EventLog result = null;
        try {
            result = (EventLog)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    public int hashCode() {
        int result = this.eventText.hashCode() + this.eventName.hashCode() + this.logId.hashCode();
        if (this.eventDetailsText != null) {
            result += this.eventDetailsText.hashCode();
        }
        if (this.timestamp != null) {
            result += this.timestamp.hashCode();
        }
        return result;
    }

    public boolean equals(Object test) {
        boolean result = false;
        if (test instanceof EventLog) {
            boolean bl = result = this.eventText.equals(((EventLog)test).eventText) && this.eventName.equals(((EventLog)test).eventName) && this.logId.equals(((EventLog)test).logId);
            if (this.eventDetailsText == null) {
                result = result && ((EventLog)test).eventDetailsText == null;
            } else {
                boolean bl2 = result = result && this.eventDetailsText.equals(((EventLog)test).eventDetailsText);
            }
            result = this.timestamp == null ? result && ((EventLog)test).timestamp == null : result && this.timestamp.equals(((EventLog)test).timestamp);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append("[").append(this.getEventText()).append(",").append(this.getTimestamp()).append(",").append(this.getEventName()).append(",").append(this.getEventDetailsText()).append(",").append(this.getLogId()).append("]");
        return result.toString();
    }

    private void marshalEventText(Log log) {
        LocalizableText text = this.getEventText();
        byte[] eventText = EventLog.buildToken(text.getResourceBundleName());
        eventText = EventLog.append(eventText, EventLog.buildToken(text.getKey()));
        log.add(eventText, (byte)-13, null);
        int substCnt = 0;
        Object[] subst = text.getSubstitutionData();
        if (subst != null) {
            for (int ix = 0; ix < subst.length; ++ix) {
                if (subst[ix] == null) {
                    subst[ix] = "";
                }
                log.add((byte)(3 + ix), Translator.toAsciiz(subst[ix].toString()));
            }
            substCnt = subst.length;
        }
        byte[] substCntData = BinaryNumber.swapByteOrder(BinaryNumber.fromInt(substCnt));
        log.add(substCntData, (byte)-15, null);
    }

    private void unmarshalEventText(Log log) {
        byte[] data = null;
        String bundleName = null;
        String key = null;
        String[] subst = null;
        LogBlock logBlock = log.getLogBlock((byte)-13);
        if (logBlock != null) {
            data = (byte[])logBlock.getData();
            int parseIx = 0;
            bundleName = EventLog.parseToken(data, parseIx);
            parseIx += 2;
            if (bundleName != null) {
                parseIx += bundleName.length();
            }
            key = EventLog.parseToken(data, parseIx);
            parseIx += 2;
            if (key != null) {
                parseIx += key.length();
            }
        }
        if (bundleName == null) {
            bundleName = "com/ibm/hwmca/fw/res/event";
        }
        if (key == null) {
            key = Short.toString(log.getUser());
        }
        if ((logBlock = log.getLogBlock((byte)-15)) != null) {
            data = (byte[])logBlock.getData();
            boolean wasShortened = false;
            if (data.length == 5 && data[0] == -1) {
                byte[] temp = new byte[data.length];
                System.arraycopy(data, 0, temp, 0, data.length);
                data = new byte[data.length - 1];
                System.arraycopy(temp, 1, data, 0, data.length - 1);
                wasShortened = true;
            }
            if (data.length == 4) {
                int substCnt = BinaryNumber.toInt(BinaryNumber.swapByteOrder(data));
                Trace.trace(TRACE_MASKF, "key=" + key + ", substCnt=" + substCnt);
                subst = new String[substCnt];
                for (int ix = 0; ix < substCnt; ++ix) {
                    logBlock = log.getLogBlock((byte)(3 + ix));
                    data = (byte[])logBlock.getData();
                    if (wasShortened && data[0] == -1) {
                        byte[] temp = new byte[data.length];
                        System.arraycopy(data, 0, temp, 0, data.length);
                        data = new byte[data.length - 1];
                        System.arraycopy(temp, 1, data, 0, data.length - 1);
                    }
                    Trace.trace(TRACE_MASKF, "data[" + ix + "]=", data);
                    subst[ix] = Translator.fromAsciiz(data);
                    Trace.trace(TRACE_MASKF, "subst[" + ix + "]='" + subst[ix] + "'");
                }
            } else {
                Trace.trace(TRACE_MASKF, "Invalid block count length. data=" + HexString.toHex(data));
            }
        }
        this.setEventText(new LocalizableText(bundleName, key, subst));
    }

    private void marshalEventDetailsText(Log log) {
        byte[] eventDetails = null;
        LocalizableText[] eventDetailsText = this.getEventDetailsText();
        if (eventDetailsText != null) {
            eventDetails = new byte[]{};
            for (int ix = 0; ix < eventDetailsText.length; ++ix) {
                eventDetails = EventLog.append(eventDetails, EventLog.marshalLocalizableText(eventDetailsText[ix]));
            }
            log.add(eventDetails, (byte)-48, null);
        }
    }

    private void unmarshalEventDetailsText(Log log) {
        ArrayList<LocalizableText> detailsList = new ArrayList<LocalizableText>();
        int detailsLength = -1;
        LocalizableText[] detailsText = null;
        LogBlock logBlock = log.getLogBlock((byte)-48);
        if (logBlock != null) {
            byte[] detailsData = (byte[])logBlock.getData();
            if (log.getLogBlock((byte)-13) == null) {
                String detailsString = Translator.fromAscii(detailsData);
                detailsText = new LocalizableText[]{new LocalizableText(detailsString)};
            } else {
                for (int parseIx = 0; parseIx < detailsData.length && detailsLength != 0; parseIx += detailsLength + 2) {
                    detailsLength = EventLog.parseLength(detailsData, parseIx);
                    LocalizableText details = EventLog.unmarshalLocalizableText(detailsData, parseIx, detailsLength);
                    detailsList.add(details);
                }
                detailsText = new LocalizableText[detailsList.size()];
                detailsList.toArray(detailsText);
            }
        }
        this.setEventDetailsText(detailsText);
    }

    private static byte[] marshalLocalizableText(LocalizableText text) {
        byte[] result = EventLog.buildToken(text.getResourceBundleName());
        result = EventLog.append(result, EventLog.buildToken(text.getKey()));
        Object[] subst = text.getSubstitutionData();
        if (subst != null) {
            for (int ix = 0; ix < subst.length; ++ix) {
                result = EventLog.append(result, EventLog.buildToken(subst[ix].toString()));
            }
        }
        result = EventLog.append(EventLog.buildLength(result.length), result);
        return result;
    }

    private static LocalizableText unmarshalLocalizableText(byte[] array, int start, int length) {
        int parseIx = start + 2;
        String bundleName = EventLog.parseToken(array, parseIx);
        parseIx += 2;
        if (bundleName != null) {
            parseIx += bundleName.length();
        }
        String key = EventLog.parseToken(array, parseIx);
        parseIx += 2;
        if (key != null) {
            parseIx += key.length();
        }
        ArrayList<String> substList = new ArrayList<String>();
        while (parseIx < start + length + 2) {
            String substValue = EventLog.parseToken(array, parseIx);
            parseIx += 2;
            if (substValue == null) continue;
            substList.add(substValue);
            parseIx += substValue.length();
        }
        Object[] subst = null;
        if (substList.size() != 0) {
            subst = new String[substList.size()];
            substList.toArray(subst);
        }
        LocalizableText result = new LocalizableText(bundleName, key, subst);
        return result;
    }

    private static byte[] buildToken(String text) {
        byte[] result = null;
        if (text == null) {
            result = EventLog.buildLength(0);
        } else {
            byte[] array = Translator.toAscii(text);
            result = new byte[array.length + 2];
            result[0] = (byte)(array.length >> 8);
            result[1] = (byte)array.length;
            System.arraycopy(array, 0, result, 2, array.length);
        }
        return result;
    }

    private static String parseToken(byte[] array, int start) {
        String result = null;
        int length = EventLog.parseLength(array, start);
        if (length > 0) {
            result = Translator.fromAscii(EventLog.subarray(array, start + 2, length));
        }
        return result;
    }

    private static byte[] append(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private static byte[] subarray(byte[] array, int start, int length) {
        if (length + start > array.length) {
            length = array.length - start;
        }
        if (length < 0) {
            length = 0;
        }
        byte[] result = new byte[length];
        if (start < array.length) {
            System.arraycopy(array, start, result, 0, length);
        }
        return result;
    }

    private static byte[] buildLength(int length) {
        byte[] result = new byte[]{(byte)(length >> 8), (byte)length};
        return result;
    }

    private static int parseLength(byte[] array, int start) {
        int result = 0;
        byte[] length = EventLog.subarray(array, start, 2);
        if (length.length == 2) {
            result = ((length[0] & 0xFF) << 8) + (length[1] & 0xFF);
        }
        return result;
    }
}

